import os
import numpy as np
import torchvision
import torch
from torchvision import transforms
from torch.utils.data.dataloader import DataLoader
from torch.utils.data.sampler import SubsetRandomSampler
from torch.utils.data import random_split
import warnings


def get_dataloaders_svhn(settings):
    # Prepare dataset
    normalize = transforms.Normalize(
        mean=[0.4914, 0.4822, 0.4465],
        std=[0.2023, 0.1994, 0.2010],
    )

    transform = transforms.Compose(
        [
            transforms.ToTensor(),
            normalize,
        ]
    )

    dataset_location = os.path.join(settings.datasets_path, settings.dataset_ood)

    test_set = torchvision.datasets.SVHN(
        root=dataset_location,
        split="test",
        download=False,
        transform=transform,
    )

    test_loader = DataLoader(
        test_set,
        batch_size=settings.batch_size,
        shuffle=False,
        num_workers=4,
        pin_memory=True,
    )

    return test_loader
